// A minimal Windows 95 skeleton //

# include <windows.h>
#include <stdio.h>
# include "spectrum.h"
# include "resource.h"

/*  Definitions contained in spectrum.h

#define RUNSCAN			WM_USER+1
#define STOPSCAN		WM_USER+2
#define UPDATE			WM_USER+3
#define CLOSESCAN		WM_USER+4
#define WM_READFREQ		WM_USER+5
#define WM_AUDIOFREE	WM_USER+6

typedef struct	{int xpos; int ypos; int width; int height; int samplespersecond; int fftsize;
					int lowbandfreq; int highbandfreq; int marker1freq; int marker2freq; int offsetfreq;
					int timescale; int avecount; int gain; int ampscale; short scrolldirection} SPECTRUMPARAM;

typedef SPECTRUMPARAM*	LPSPECTRUMPARAM;

extern HWND				SpectrumWindow (HWND, HINSTANCE, LPSPECTRUMPARAM);

*/

SPECTRUMPARAM		SpectrumParam;
HANDLE				ghInstance, hSpectrumBuffer;
HWND				hwnd, hOpenWindow, hSpectrumWindow, hMessageDialog;
short				*lpSpectrumBuffer;
int					nScreenWidth, nScreenHeight, nSpectrumBufferSize, nSpectrumLength;
BYTE				nAudioWindowFlag, nAudioInUseFlag, nCloseItFlag;
char				szBuffer[80];

BOOL CALLBACK MessageDlgProc (HWND, UINT, WPARAM, LPARAM);

LRESULT CALLBACK	WindowFunc(HWND, UINT, WPARAM, LPARAM);

char szWinName[] = "SimpleWin";

int WINAPI WinMain (HINSTANCE hThisInst, HINSTANCE hPrevInst, LPSTR lpszArgs, int nWinMode)

{
	MSG  msg;
	WNDCLASSEX wcl;

	// Define a Windows Class //

	wcl.hInstance = hThisInst;
	ghInstance = hThisInst;
	wcl.lpszClassName = szWinName;
	wcl.lpfnWndProc = WindowFunc;
	wcl.style = 0;
	wcl.cbSize = sizeof(WNDCLASSEX);
	wcl.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wcl.hIconSm = LoadIcon(NULL, IDI_WINLOGO);
	wcl.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcl.lpszMenuName = NULL;
	wcl.cbClsExtra = 0;
	wcl.cbWndExtra = 0;
	wcl.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);

	// Register the Window Class //

	if(!RegisterClassEx(&wcl)) return 0;

	// Create Application Window //

	hwnd = CreateWindow(
		szWinName,
		"Application Window",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,			// X Coordinate
		CW_USEDEFAULT,			// Y Coordinate
		CW_USEDEFAULT,			// Width
		CW_USEDEFAULT,			// Height
		HWND_DESKTOP,			// No Parent Window
		NULL,					// Menu
		hThisInst,				// This Instance
		NULL					// Additional Arguments
	);

	// Display the Application Window  //

	ShowWindow (hwnd, nWinMode);
	UpdateWindow(hwnd);

	// Create the Message Loop //

	while (GetMessage (&msg, NULL, 0, 0))
	{
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}

	return msg.wParam;
}

// Application Window Function called by Win95 which is passed messages from the message queue. //

LRESULT CALLBACK WindowFunc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)  {

	case WM_CREATE:

		nScreenWidth = (GetSystemMetrics(SM_CXSCREEN));
    	nScreenHeight = (GetSystemMetrics(SM_CYSCREEN));
		MoveWindow(hwnd, 0, 0, nScreenWidth, nScreenHeight, FALSE);

		SpectrumParam.xpos = (nScreenWidth/2-380)/2;
		SpectrumParam.ypos = (nScreenHeight-300)/2;
		SpectrumParam.width = 380;
		SpectrumParam.height = 300;
		SpectrumParam.samplespersecond = 22050;
		SpectrumParam.fftsize = 2048;
		SpectrumParam.lowbandfreq = 0;
		SpectrumParam.highbandfreq = 4000;
		SpectrumParam.marker1freq = 0;
		SpectrumParam.marker2freq = 0;
		SpectrumParam.offsetfreq = 0;
		SpectrumParam.timescale = 5;
		SpectrumParam.avecount = 0;
		SpectrumParam.gain = 15;
		SpectrumParam.ampscale = 60;
		SpectrumParam.scrolldirection = 0;

		// Create the dialog box containing frequency scan controls
		
		hMessageDialog = CreateDialog (ghInstance, (LPCTSTR)IDD_DIALOG1, hwnd, (DLGPROC)MessageDlgProc);
		break;

	case WM_READFREQ:

		// Message from Spectrum Window with frequency readout

		sprintf (szBuffer, " Frequency at Cursor:  %-0u Hz", lParam);
		SetWindowText (hwnd, szBuffer);
		break;

	case WM_CLOSE:

		if(nAudioInUseFlag==1)  {

			// Wait for Audio Free message before closing application window
			
			nAudioWindowFlag = 0;
			nCloseItFlag = 1;

			// Message to Spectrum Window to close down. Returns WM_AUDIOFREE message
			
			SendMessage(hSpectrumWindow, WM_COMMAND, CLOSESCAN, 0l);
			break;
		}

		else DestroyWindow(hwnd);

	case WM_AUDIOFREE:

		// Message from Spectrum Window that audio processing has stopped

		nAudioInUseFlag = 0;
		if(lParam==1) nAudioWindowFlag = 0;

		if(nCloseItFlag==1) DestroyWindow(hwnd);
		break;
	
	case WM_DESTROY:

		PostQuitMessage(0);
		break;
	
	default:

		return DefWindowProc(hwnd, message, wParam, lParam);    
	}

	return 0;
}

// ****************************** Message Dlg Proc ******************************

// Dialog box containing the frequency scan controls

BOOL CALLBACK MessageDlgProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)  {
							       
    RECT			rDialogRect, rPlotRect;
    int				i;
	static int		nDialogX, nDialogY, nDialogWidth, nDialogHeight, nScrollPick, 
					nHeight, nPlotWidth, nPlotHeight;
	static float	flStep;
	static char		nSpectrumFlag;
	static			HWND hPlot;
	static			HDC	 hPlotDC;
	static			HANDLE	hSpectrumData;
	static			HPEN hPlotPen;
	static short	*lpSpectrumData;

    switch (message)  {
     
		case WM_INITDIALOG:

			GetWindowRect(hDlg, &rDialogRect);
			nDialogWidth = rDialogRect.right - rDialogRect.left;
			nDialogHeight = rDialogRect.bottom - rDialogRect.top;
			nDialogX = nScreenWidth/2+(nScreenWidth/2-nDialogWidth)/2;
			nDialogY = (nScreenHeight-nDialogHeight)/2;
			MoveWindow(hDlg, nDialogX, nDialogY, nDialogWidth, nDialogHeight, TRUE);

			SetDlgItemInt(hDlg, IDC_XPOS, SpectrumParam.xpos, FALSE);
			SetDlgItemInt(hDlg, IDC_YPOS, SpectrumParam.ypos, FALSE);
			SetDlgItemInt(hDlg, IDC_WIDTH, SpectrumParam.width, FALSE);
			SetDlgItemInt(hDlg, IDC_HEIGHT, SpectrumParam.height, FALSE);
			SetDlgItemInt(hDlg, IDC_SAMPLESPERSECOND, SpectrumParam.samplespersecond, FALSE);
			SetDlgItemInt(hDlg, IDC_FFTSIZE, SpectrumParam.fftsize, FALSE);
			SetDlgItemInt(hDlg, IDC_LOWBANDFREQ, SpectrumParam.lowbandfreq, FALSE);
			SetDlgItemInt(hDlg, IDC_HIGHBANDFREQ, SpectrumParam.highbandfreq, FALSE);
			SetDlgItemInt(hDlg, IDC_MARKER1FREQ, SpectrumParam.marker1freq, FALSE);
			SetDlgItemInt(hDlg, IDC_MARKER2FREQ, SpectrumParam.marker2freq, FALSE);
			SetDlgItemInt(hDlg, IDC_OFFSETFREQ, SpectrumParam.offsetfreq, TRUE);
			SetDlgItemInt(hDlg, IDC_TIMESCALE, SpectrumParam.timescale, FALSE);
			SetDlgItemInt(hDlg, IDC_AVECOUNT, SpectrumParam.avecount, FALSE);
			SetDlgItemInt(hDlg, IDC_GAIN, SpectrumParam.gain, FALSE);
			SetDlgItemInt(hDlg, IDC_AMPSCALE, SpectrumParam.ampscale, FALSE);
			
			if(SpectrumParam.scrolldirection==0) nScrollPick = IDC_RIGHTLEFT;
			else nScrollPick = IDC_WATERFALL;
			CheckRadioButton(hDlg, IDC_RIGHTLEFT, IDC_WATERFALL, nScrollPick);

			hPlotPen = CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
			return (TRUE);

		case WM_READSPECTRUM:

			hSpectrumBuffer = (HANDLE)lParam;
			nSpectrumFlag = 1;

			InvalidateRect (hDlg, NULL, FALSE);
			UpdateWindow (hDlg);
			return (TRUE);

		case WM_COMMAND:

			switch (wParam)  {

			case IDC_START:

				SpectrumParam.xpos = GetDlgItemInt(hDlg, IDC_XPOS, NULL, 0);
				SpectrumParam.ypos = GetDlgItemInt(hDlg, IDC_YPOS, NULL, 0);
				SpectrumParam.width = GetDlgItemInt(hDlg, IDC_WIDTH, NULL, 0);
				SpectrumParam.height = GetDlgItemInt(hDlg, IDC_HEIGHT, NULL, 0);
				SpectrumParam.samplespersecond = GetDlgItemInt(hDlg, IDC_SAMPLESPERSECOND, NULL, 0);
				SpectrumParam.fftsize = GetDlgItemInt(hDlg, IDC_FFTSIZE, NULL, 0);
				SpectrumParam.lowbandfreq = GetDlgItemInt(hDlg, IDC_LOWBANDFREQ, NULL, 0);
				SpectrumParam.highbandfreq = GetDlgItemInt(hDlg, IDC_HIGHBANDFREQ, NULL, 0);
				SpectrumParam.marker1freq = GetDlgItemInt(hDlg, IDC_MARKER1FREQ, NULL, 0);
				SpectrumParam.marker2freq = GetDlgItemInt(hDlg, IDC_MARKER2FREQ, NULL, 0);
				SpectrumParam.offsetfreq = GetDlgItemInt(hDlg, IDC_OFFSETFREQ, NULL, 1);
				SpectrumParam.timescale = GetDlgItemInt(hDlg, IDC_TIMESCALE, NULL, 0);
				SpectrumParam.avecount = GetDlgItemInt(hDlg, IDC_AVECOUNT, NULL, 0);
				SpectrumParam.gain = GetDlgItemInt(hDlg, IDC_GAIN, NULL, 0);
				SpectrumParam.ampscale = GetDlgItemInt(hDlg, IDC_AMPSCALE, NULL, 0);

				if(nScrollPick==IDC_RIGHTLEFT) SpectrumParam.scrolldirection = 0;
				if(nScrollPick==IDC_WATERFALL) SpectrumParam.scrolldirection = 1;

				if(nAudioWindowFlag==0)  {

					// dll Function to start Spectrum Window

					nAudioWindowFlag = 1;
					hSpectrumWindow = SpectrumWindow (hwnd, ghInstance, &SpectrumParam);
				}
				
				if(nAudioInUseFlag==0)  {

					// Message to Spectrum Window to start processing data

					nAudioInUseFlag = 1;
					SendMessage (hSpectrumWindow, WM_COMMAND, RUNSCAN, (long)&SpectrumParam);
				}
				
				return (TRUE);

			case IDC_SEND:  

				SpectrumParam.xpos = GetDlgItemInt(hDlg, IDC_XPOS, NULL, 0);
				SpectrumParam.ypos = GetDlgItemInt(hDlg, IDC_YPOS, NULL, 0);
				SpectrumParam.width = GetDlgItemInt(hDlg, IDC_WIDTH, NULL, 0);
				SpectrumParam.height = GetDlgItemInt(hDlg, IDC_HEIGHT, NULL, 0);
				SpectrumParam.samplespersecond = GetDlgItemInt(hDlg, IDC_SAMPLESPERSECOND, NULL, 0);
				SpectrumParam.fftsize = GetDlgItemInt(hDlg, IDC_FFTSIZE, NULL, 0);
				SpectrumParam.lowbandfreq = GetDlgItemInt(hDlg, IDC_LOWBANDFREQ, NULL, 0);
				SpectrumParam.highbandfreq = GetDlgItemInt(hDlg, IDC_HIGHBANDFREQ, NULL, 0);
				SpectrumParam.marker1freq = GetDlgItemInt(hDlg, IDC_MARKER1FREQ, NULL, 0);
				SpectrumParam.marker2freq = GetDlgItemInt(hDlg, IDC_MARKER2FREQ, NULL, 0);
				SpectrumParam.offsetfreq = GetDlgItemInt(hDlg, IDC_OFFSETFREQ, NULL, 1);
				SpectrumParam.timescale = GetDlgItemInt(hDlg, IDC_TIMESCALE, NULL, 0);
				SpectrumParam.avecount = GetDlgItemInt(hDlg, IDC_AVECOUNT, NULL, 0);
				SpectrumParam.gain = GetDlgItemInt(hDlg, IDC_GAIN, NULL, 0);
				SpectrumParam.ampscale = GetDlgItemInt(hDlg, IDC_AMPSCALE, NULL, 0);

				if(nScrollPick==IDC_RIGHTLEFT) SpectrumParam.scrolldirection = 0;
				if(nScrollPick==IDC_WATERFALL) SpectrumParam.scrolldirection = 1;
				
				if((nAudioWindowFlag==1)&&(nAudioInUseFlag==1))

					// Message to Spectum Window to update parameters
				
					SendMessage (hSpectrumWindow, WM_COMMAND, UPDATE, (long)&SpectrumParam);
				
				return (TRUE);

			case IDC_RIGHTLEFT:
			case IDC_WATERFALL:

				nScrollPick = wParam;
				CheckRadioButton(hDlg, IDC_RIGHTLEFT, IDC_WATERFALL, nScrollPick);
				return (TRUE);

			case IDC_STOP:

				if((nAudioWindowFlag==1)&&(nAudioInUseFlag==1))

					// Message to Spectrum Window to stop processing data

					SendMessage(hSpectrumWindow, WM_COMMAND, STOPSCAN, 0l);
				
				return (TRUE);

			case IDC_CLOSE:

				if(nAudioWindowFlag==1)  {

					// Message to Spectrum Window to close down

					nAudioWindowFlag=0;
					SendMessage(hSpectrumWindow, WM_COMMAND, CLOSESCAN, 0l);
				}

				return (TRUE);

			case IDC_GET:

				if(nSpectrumFlag==1)  {

					GlobalFree(hSpectrumBuffer);
					nSpectrumFlag = 0;
				}

				SendMessage(hSpectrumWindow, WM_COMMAND, GETSPECTRUM, (long)hDlg);
				return (TRUE);
			
			case IDCANCEL:

				if(nSpectrumFlag==1)  {

					GlobalFree(hSpectrumBuffer);
					nSpectrumFlag = 0;
				}

				DeleteObject(hPlotPen);
				EndDialog (hDlg, FALSE) ;
				return (TRUE) ;
		}
	    break ;

		case WM_PAINT:

			if(nSpectrumFlag==0) break;

			hPlot = GetDlgItem(hDlg, IDC_PLOT);

			GetClientRect(hPlot, &rPlotRect);
			nPlotWidth = rPlotRect.right - rPlotRect.left;
			nPlotHeight = rPlotRect.bottom - rPlotRect.top;

			InvalidateRect(hPlot, NULL, TRUE);
			UpdateWindow(hPlot);

			hPlotDC = GetDC(hPlot);
			SelectObject(hPlotDC, hPlotPen);

			lpSpectrumBuffer = GlobalLock(hSpectrumBuffer);
			nSpectrumLength = (SpectrumParam.fftsize)/2;
			flStep = (float)nSpectrumLength/(float)nPlotWidth;

			MoveToEx(hPlotDC, 0, nPlotHeight, NULL);
			
			for(i=0; i<nPlotWidth; i++)  {

				nHeight = nPlotHeight-((lpSpectrumBuffer[(int)(i*flStep)])+90);
				if(nHeight<0) nHeight = 0;
				if(nHeight>nPlotHeight) nHeight = nPlotHeight;

				LineTo(hPlotDC, i, nHeight);
			}

			GlobalUnlock(hSpectrumBuffer);
			ReleaseDC(hDlg, hPlotDC);

			break ;
	}
    return (FALSE) ;
}
